
;;######################################################################
;;
;; ViSta - The Visual Statistics System
;; Copyright (c) 1991-99 by Forrest W. Young
;; For further information contact the author 
;; forrest@unc.edu or http://forrest.psych.unc.edu
;;
;; This file determines Macintosh configuration 
;; for directories, window layout, and startup privileges
;; and then initiates loading of program files
;;
;;####################################################################
 

;;####################################################################
;;
;;GET CURRENT INSTALLATION INFO
;;
;;####################################################################

(setf *default-dir*     *default-path*)

(setf *working-dir*     (get-working-directory))
(setf *working-path*    (strcat *working-dir*));???win
(setf *startup-path*    (strcat *working-dir* *separator*))
(setf prefs-dir? (load-initial-file))

(setf *lib-path*   *working-path*)
(setf *user-path*  (strcat *lib-path* "user:"))
(setf *prefs-path* (strcat *lib-path* "prefs:"))
(setf *xlib-path*  *lib-path*)
(setf *prefs-dir-name* *prefs-path*)

;;####################################################################
;;
;; DO INITIAL INSTALLATION
;;
;;####################################################################

(let* ((prefs-dir? (load-initial-file))
       )
  (when (or *initial-install* (not prefs-dir?))
        (dribble "install.log")
        (verbose t)
        (format t "Installation Process Initiated.~%")
        (when *initial-install* (format t "Initial Installation~%"))
        (when (not prefs-dir?) (format t "No Valid PrefLoad file~%"))
        (format t "~%Configuring user profile.~%")
        (setf *macos8* (yes-or-no-dialog "Do you use MacOS8-style windows?"))                         
        (setf *update-pref-files* t)
        (setf *configure* t)
        (setf *change-directories* t)
        (setf *change-fonts* t)
        (setf *change-profiles* t)
        (setf *author* nil)
        (setf *show-devel-menu* nil)
        (write-prefload-file)
        (format t "Installation Process Completed.~2%.~%~%")
        ))
 
;;####################################################################
;;
;; DEFINE ALL PATHNAMES
;;
;;####################################################################
   
(when *v* (format t "Defining Paths~%"))

(SETF PREFLOAD-FILE? (READ-PREFLOAD-FILE))

(when (= 0 (length *default-path*)) (setf *default-path* *lib-path*))

(setf *startup-dir-name*  *startup-path* )
(setf *prefs-dir-name*    *prefs-path*)
(setf *user-dir-name*     *user-path*)

(setf *default-dir*       *default-path*)
(setf *vista-dir-name*    (strcat *default-dir* "code" *separator*))
(setf *data-dir-name*     (strcat *default-dir* "data" *separator*))
(setf *current-data-dir-name* *data-dir-name*)
(setf *code-dir-name*     (strcat *default-dir* "code" *separator*))
(setf *base-dir-name*     (strcat *default-dir* "base" *separator*))
(setf *example-dir-name*  (strcat *default-dir* "examples" *separator*))
(setf *examples-dir-name* (strcat *default-dir* "examples" *separator*))
(setf *examples-data-dir-name* (strcat *default-dir* "data" *separator*))
(setf *help-dir-name*     (strcat *default-dir* "code" separator "help" *separator*))
(setf *guide-dir-name*    (strcat *default-dir* "code" separator "guidance" *separator*))
(setf *plugin-dir-name*   (strcat *default-dir* "plugins" *separator*))
(setf *plugins-dir-name*  (strcat *default-dir* "plugins" *separator*))
(setf *plugins-path*      *plugins-dir-name*)
(setf *plugin-path*       *plugins-dir-name*)

(when *v*       
      (format t "; root  path: ~a~%" *default-path*)
      (format t "; prefs path: ~a~%"   *prefs-path*)
      (format t "; user  path: ~a~%"   *user-path*)
      
      )

(setf *pro-version* (not (not (probe-base-file))))
(when (and *pro-version* (= *run-number* 0))
      (setf *show-devel-menu* t))

(when *v* (print-paths)(print-initial-variables))

(setf *initial-install* nil)
(setf *run-number* (1+ *run-number*))


(defun repeat-command ()
"Repeats previous command.  Written by Frederic Udina."
  (send *listener* :paste-string (string-downcase (format nil "~s" -)))
  (send *listener* :show-window))

(defun add-repeat-to-menu ()
; Next statement prevents error if calling the repeat function before
; - is defined by the first read
  (setq - nil)
  (send *command-menu*
        :append-items
        (send menu-item-proto
              :new "Repeat Command"
              :action 'repeat-command
              :key #\')))

(add-repeat-to-menu)

;; LOAD ViSta

(when *v* (format t "Loading ViSta~2%"))
(setf *version-string* (strcat *version-string* (format nil " (~a)" *run-number*)))
(validate-user-path)
(verbose t)
(defun load-vista ()
  (let ((yesno t)
        )
    (when ask-load-vista
          (setf yesno (two-button-dialog (format nil "XLisp-Stat has been loaded.~%Load ViSta as well?") :first-button "Please Do" :second-button "No Thanks")))
    (when yesno
          (expand 100)
          (verbose nil)
          (when (not (load (strcat *vista-dir-name* "vista")
                           :if-does-not-exist nil))
                (message-dialog (format nil "ViSta must be configured for this machine.~%Click OK, then Quit and Rerun."))
                (setf *no-dir-dialog* t)
                (when (not (load "config.lsp" :if-does-not-exist nil))
                      (message-dialog 
                       (format nil 
"ERROR:~2%ViSta was not found in:~2%~a~2%This may be because old versions of the ViStaXLS.INI file exist.~%Make sure all copies are removed and try again. This should ~%automatically create a new, correct ViStaXLS.INI file.~2%If you still have problems, you should try loading the~%CONFIG.LSP file to configure a new ViStaXLS.INI file.~2%If you still have problems, restructure your files so that~%ViSta is in the directory mentioned above.~% " *vista-dir-name*) t)
                      )))))

(defun no-user-dir ()
  (let ((dir-now (get-working-directory))
        (yesno (two-button-dialog (format nil "USER directory not found.~%You cannot save results.~%Continue anyway?") :first-button "Continue" :second-button "Exit ViSta"))
        )
    (if yesno (load-vista) (exit))))

(if *user-path* (load-vista) (no-user-dir))

(provide "wininit")

